/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
////////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.


////////////////////////////////////////////////////////////////////////////////////
// Start your functions here.

BOOL AccessingDataRange()
{
	Worksheet wks = Project.ActiveLayer(); // Get active worksheet layer
	if( wks.IsValid() ) // If wks is valid..
	{
		uint nCols = wks.Columns.Count(); // Get number of columns in worksheet
		nCols = nCols > 10 ? 10 : nCols; // Maximum number of columns is 10
		
		DataRange dr;    //Declear a DataRange 
		
		dr.Add("X", wks, 0, 0, -1, 0);     //Add subRange 'X'
		
		for(int ii = 1; ii < nCols; ii++)
			dr.Add("Y", wks, 0, ii, -1, ii);      //Add subRange 'Y'
		
		vector vXVals,vYVals;
		dr.GetData(vXVals, 0);                    //Get the first column Data
		dr.GetData(vYVals, 1);                    //get the second column Data
		
		vYVals = vXVals * 10;                    
		dr.SetData(&vYVals, &vXVals);            //set the Column1 = Column0 * 10; just for fun
		return TRUE;
	}

	return FALSE;
}